<?php
/* --------------------------------------------------------------
   SqlPagination.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Criteria;

use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Interface SqlPagination
 *
 * @package Gambio\Core\SqlCriteria\Interfaces
 */
interface SqlPagination
{
    /**
     * Applies internal pagination settings to provided query builder instance.
     *
     * @param QueryBuilder $query
     */
    public function applyToQuery(QueryBuilder $query): void;
}